/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBPluginTyped = Object.create(STBModule.prototype);

STBPluginTyped.name = "PluginTyped";

STBPluginTyped.initPlugin = function() {
	
	var elements = $(".typed:not(.__done)");

	if (elements.length) {

		elements.each(function() {
			var obj = $(this),
				strings		= obj.attr("data-text").split("|"),
				speed		= parseInt(obj.attr("data-speed")),
				loop		= STBUtils.attrDefaultValue(obj.attr("data-loop") , "true"),
				cursor		= STBUtils.attrDefaultValue(obj.attr("data-cursor") , "|")
				shuffle		= STBUtils.attrDefaultValue(obj.attr("data-shuffle") , "true");

			obj.typed({
				strings			: strings,
				typeSpeed		: speed,
				loop			: loop == "true" ? true : false,
				fadeOut			: false,
				backDelay		: 500,
				shuffle			: shuffle == "true" ? true : false,
				backSpeed		: 0,
				fadeOutClass	: 'typed-fade-out',
				fadeOutDelay	: 500, 
				cursorChar		: cursor,

			});

			obj.css ("opacity" , "1");
			obj.addClass("__done");
		});
	}
}

STBPluginTyped.runOnReady = function() {
	STBPluginTyped.initPlugin();
}

STBPluginTyped.runOnContentUpdate = function() {
	STBPluginTyped.initPlugin();
}

site.registerModule(STBPluginTyped);